// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Build service resource properties payload.
 */
@Fluent
public final class BuildServiceProperties implements JsonSerializable<BuildServiceProperties> {
    /*
     * The resource id of the container registry used in this build service.
     */
    private String containerRegistry;

    /*
     * The installed KPack version in this build service.
     */
    private String kPackVersion;

    /*
     * Provisioning state of the KPack build service
     */
    private BuildServiceProvisioningState provisioningState;

    /*
     * The runtime resource configuration of this build service.
     */
    private BuildServicePropertiesResourceRequests resourceRequests;

    /**
     * Creates an instance of BuildServiceProperties class.
     */
    public BuildServiceProperties() {
    }

    /**
     * Get the containerRegistry property: The resource id of the container registry used in this build service.
     * 
     * @return the containerRegistry value.
     */
    public String containerRegistry() {
        return this.containerRegistry;
    }

    /**
     * Set the containerRegistry property: The resource id of the container registry used in this build service.
     * 
     * @param containerRegistry the containerRegistry value to set.
     * @return the BuildServiceProperties object itself.
     */
    public BuildServiceProperties withContainerRegistry(String containerRegistry) {
        this.containerRegistry = containerRegistry;
        return this;
    }

    /**
     * Get the kPackVersion property: The installed KPack version in this build service.
     * 
     * @return the kPackVersion value.
     */
    public String kPackVersion() {
        return this.kPackVersion;
    }

    /**
     * Get the provisioningState property: Provisioning state of the KPack build service.
     * 
     * @return the provisioningState value.
     */
    public BuildServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceRequests property: The runtime resource configuration of this build service.
     * 
     * @return the resourceRequests value.
     */
    public BuildServicePropertiesResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The runtime resource configuration of this build service.
     * 
     * @param resourceRequests the resourceRequests value to set.
     * @return the BuildServiceProperties object itself.
     */
    public BuildServiceProperties withResourceRequests(BuildServicePropertiesResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerRegistry", this.containerRegistry);
        jsonWriter.writeJsonField("resourceRequests", this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildServiceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildServiceProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildServiceProperties.
     */
    public static BuildServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildServiceProperties deserializedBuildServiceProperties = new BuildServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containerRegistry".equals(fieldName)) {
                    deserializedBuildServiceProperties.containerRegistry = reader.getString();
                } else if ("kPackVersion".equals(fieldName)) {
                    deserializedBuildServiceProperties.kPackVersion = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBuildServiceProperties.provisioningState
                        = BuildServiceProvisioningState.fromString(reader.getString());
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedBuildServiceProperties.resourceRequests
                        = BuildServicePropertiesResourceRequests.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildServiceProperties;
        });
    }
}
