// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Build service agent pool size properties.
 */
@Fluent
public final class BuildServiceAgentPoolSizeProperties
    implements JsonSerializable<BuildServiceAgentPoolSizeProperties> {
    /*
     * The name of build service agent pool size
     */
    private String name;

    /*
     * The cpu property of build service agent pool size
     */
    private String cpu;

    /*
     * The memory property of build service agent pool size
     */
    private String memory;

    /**
     * Creates an instance of BuildServiceAgentPoolSizeProperties class.
     */
    public BuildServiceAgentPoolSizeProperties() {
    }

    /**
     * Get the name property: The name of build service agent pool size.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of build service agent pool size.
     * 
     * @param name the name value to set.
     * @return the BuildServiceAgentPoolSizeProperties object itself.
     */
    public BuildServiceAgentPoolSizeProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the cpu property: The cpu property of build service agent pool size.
     * 
     * @return the cpu value.
     */
    public String cpu() {
        return this.cpu;
    }

    /**
     * Get the memory property: The memory property of build service agent pool size.
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildServiceAgentPoolSizeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildServiceAgentPoolSizeProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildServiceAgentPoolSizeProperties.
     */
    public static BuildServiceAgentPoolSizeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildServiceAgentPoolSizeProperties deserializedBuildServiceAgentPoolSizeProperties
                = new BuildServiceAgentPoolSizeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedBuildServiceAgentPoolSizeProperties.name = reader.getString();
                } else if ("cpu".equals(fieldName)) {
                    deserializedBuildServiceAgentPoolSizeProperties.cpu = reader.getString();
                } else if ("memory".equals(fieldName)) {
                    deserializedBuildServiceAgentPoolSizeProperties.memory = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildServiceAgentPoolSizeProperties;
        });
    }
}
