// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ActionType;
import com.azure.resourcemanager.appplatform.models.OperationDisplay;
import com.azure.resourcemanager.appplatform.models.OperationProperties;
import java.io.IOException;

/**
 * Operation detail payload.
 */
@Fluent
public final class OperationDetailInner implements JsonSerializable<OperationDetailInner> {
    /*
     * Name of the operation
     */
    private String name;

    /*
     * Indicates whether the operation is a data action
     */
    private Boolean isDataAction;

    /*
     * Display of the operation
     */
    private OperationDisplay display;

    /*
     * Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
     */
    private ActionType actionType;

    /*
     * Origin of the operation
     */
    private String origin;

    /*
     * Properties of the operation
     */
    private OperationProperties properties;

    /**
     * Creates an instance of OperationDetailInner class.
     */
    public OperationDetailInner() {
    }

    /**
     * Get the name property: Name of the operation.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the operation.
     * 
     * @param name the name value to set.
     * @return the OperationDetailInner object itself.
     */
    public OperationDetailInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the isDataAction property: Indicates whether the operation is a data action.
     * 
     * @return the isDataAction value.
     */
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    /**
     * Set the isDataAction property: Indicates whether the operation is a data action.
     * 
     * @param isDataAction the isDataAction value to set.
     * @return the OperationDetailInner object itself.
     */
    public OperationDetailInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    /**
     * Get the display property: Display of the operation.
     * 
     * @return the display value.
     */
    public OperationDisplay display() {
        return this.display;
    }

    /**
     * Set the display property: Display of the operation.
     * 
     * @param display the display value to set.
     * @return the OperationDetailInner object itself.
     */
    public OperationDetailInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    /**
     * Get the actionType property: Enum. Indicates the action type. "Internal" refers to actions that are for internal
     * only APIs.
     * 
     * @return the actionType value.
     */
    public ActionType actionType() {
        return this.actionType;
    }

    /**
     * Get the origin property: Origin of the operation.
     * 
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Set the origin property: Origin of the operation.
     * 
     * @param origin the origin value to set.
     * @return the OperationDetailInner object itself.
     */
    public OperationDetailInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    /**
     * Get the properties property: Properties of the operation.
     * 
     * @return the properties value.
     */
    public OperationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the operation.
     * 
     * @param properties the properties value to set.
     * @return the OperationDetailInner object itself.
     */
    public OperationDetailInner withProperties(OperationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (display() != null) {
            display().validate();
        }
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationDetailInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationDetailInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationDetailInner.
     */
    public static OperationDetailInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationDetailInner deserializedOperationDetailInner = new OperationDetailInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOperationDetailInner.name = reader.getString();
                } else if ("isDataAction".equals(fieldName)) {
                    deserializedOperationDetailInner.isDataAction = reader.getNullable(JsonReader::getBoolean);
                } else if ("display".equals(fieldName)) {
                    deserializedOperationDetailInner.display = OperationDisplay.fromJson(reader);
                } else if ("actionType".equals(fieldName)) {
                    deserializedOperationDetailInner.actionType = ActionType.fromString(reader.getString());
                } else if ("origin".equals(fieldName)) {
                    deserializedOperationDetailInner.origin = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedOperationDetailInner.properties = OperationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationDetailInner;
        });
    }
}
