// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorValidateResultState;
import java.io.IOException;

/**
 * Validation result for customized accelerator properties.
 */
@Fluent
public final class CustomizedAcceleratorValidateResultInner
    implements JsonSerializable<CustomizedAcceleratorValidateResultInner> {
    /*
     * State of the customized accelerator validation result
     */
    private CustomizedAcceleratorValidateResultState state;

    /*
     * The detail validation results
     */
    private String errorMessage;

    /**
     * Creates an instance of CustomizedAcceleratorValidateResultInner class.
     */
    public CustomizedAcceleratorValidateResultInner() {
    }

    /**
     * Get the state property: State of the customized accelerator validation result.
     * 
     * @return the state value.
     */
    public CustomizedAcceleratorValidateResultState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the customized accelerator validation result.
     * 
     * @param state the state value to set.
     * @return the CustomizedAcceleratorValidateResultInner object itself.
     */
    public CustomizedAcceleratorValidateResultInner withState(CustomizedAcceleratorValidateResultState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the errorMessage property: The detail validation results.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage property: The detail validation results.
     * 
     * @param errorMessage the errorMessage value to set.
     * @return the CustomizedAcceleratorValidateResultInner object itself.
     */
    public CustomizedAcceleratorValidateResultInner withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomizedAcceleratorValidateResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomizedAcceleratorValidateResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomizedAcceleratorValidateResultInner.
     */
    public static CustomizedAcceleratorValidateResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomizedAcceleratorValidateResultInner deserializedCustomizedAcceleratorValidateResultInner
                = new CustomizedAcceleratorValidateResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedCustomizedAcceleratorValidateResultInner.state
                        = CustomizedAcceleratorValidateResultState.fromString(reader.getString());
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedCustomizedAcceleratorValidateResultInner.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomizedAcceleratorValidateResultInner;
        });
    }
}
