// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * ExecAction describes a "run in container" action.
 */
@Fluent
public final class ExecAction extends ProbeAction {
    /*
     * The type of the action to take to perform the health check.
     */
    private ProbeActionType type = ProbeActionType.EXEC_ACTION;

    /*
     * Command is the command line to execute inside the container, the working directory for the command is root ('/')
     * in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|',
     * etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     */
    private List<String> command;

    /**
     * Creates an instance of ExecAction class.
     */
    public ExecAction() {
    }

    /**
     * Get the type property: The type of the action to take to perform the health check.
     * 
     * @return the type value.
     */
    @Override
    public ProbeActionType type() {
        return this.type;
    }

    /**
     * Get the command property: Command is the command line to execute inside the container, the working directory for
     * the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional
     * shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit
     * status of 0 is treated as live/healthy and non-zero is unhealthy.
     * 
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: Command is the command line to execute inside the container, the working directory for
     * the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional
     * shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit
     * status of 0 is treated as live/healthy and non-zero is unhealthy.
     * 
     * @param command the command value to set.
     * @return the ExecAction object itself.
     */
    public ExecAction withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExecAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExecAction if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ExecAction.
     */
    public static ExecAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExecAction deserializedExecAction = new ExecAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedExecAction.type = ProbeActionType.fromString(reader.getString());
                } else if ("command".equals(fieldName)) {
                    List<String> command = reader.readArray(reader1 -> reader1.getString());
                    deserializedExecAction.command = command;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExecAction;
        });
    }
}
