// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Object that includes an array of Deployment resource name and set them as active.
 */
@Fluent
public final class ActiveDeploymentCollection implements JsonSerializable<ActiveDeploymentCollection> {
    /*
     * Collection of Deployment name.
     */
    private List<String> activeDeploymentNames;

    /**
     * Creates an instance of ActiveDeploymentCollection class.
     */
    public ActiveDeploymentCollection() {
    }

    /**
     * Get the activeDeploymentNames property: Collection of Deployment name.
     * 
     * @return the activeDeploymentNames value.
     */
    public List<String> activeDeploymentNames() {
        return this.activeDeploymentNames;
    }

    /**
     * Set the activeDeploymentNames property: Collection of Deployment name.
     * 
     * @param activeDeploymentNames the activeDeploymentNames value to set.
     * @return the ActiveDeploymentCollection object itself.
     */
    public ActiveDeploymentCollection withActiveDeploymentNames(List<String> activeDeploymentNames) {
        this.activeDeploymentNames = activeDeploymentNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("activeDeploymentNames", this.activeDeploymentNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActiveDeploymentCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActiveDeploymentCollection if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ActiveDeploymentCollection.
     */
    public static ActiveDeploymentCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveDeploymentCollection deserializedActiveDeploymentCollection = new ActiveDeploymentCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("activeDeploymentNames".equals(fieldName)) {
                    List<String> activeDeploymentNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedActiveDeploymentCollection.activeDeploymentNames = activeDeploymentNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActiveDeploymentCollection;
        });
    }
}
