// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Error record of the config server settings.
 */
@Fluent
public final class ConfigServerSettingsErrorRecord implements JsonSerializable<ConfigServerSettingsErrorRecord> {
    /*
     * The name of the config server settings error record
     */
    private String name;

    /*
     * The uri of the config server settings error record
     */
    private String uri;

    /*
     * The detail error messages of the record
     */
    private List<String> messages;

    /**
     * Creates an instance of ConfigServerSettingsErrorRecord class.
     */
    public ConfigServerSettingsErrorRecord() {
    }

    /**
     * Get the name property: The name of the config server settings error record.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the config server settings error record.
     * 
     * @param name the name value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the uri property: The uri of the config server settings error record.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The uri of the config server settings error record.
     * 
     * @param uri the uri value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the messages property: The detail error messages of the record.
     * 
     * @return the messages value.
     */
    public List<String> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: The detail error messages of the record.
     * 
     * @param messages the messages value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withMessages(List<String> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigServerSettingsErrorRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigServerSettingsErrorRecord if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigServerSettingsErrorRecord.
     */
    public static ConfigServerSettingsErrorRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigServerSettingsErrorRecord deserializedConfigServerSettingsErrorRecord
                = new ConfigServerSettingsErrorRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedConfigServerSettingsErrorRecord.name = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedConfigServerSettingsErrorRecord.uri = reader.getString();
                } else if ("messages".equals(fieldName)) {
                    List<String> messages = reader.readArray(reader1 -> reader1.getString());
                    deserializedConfigServerSettingsErrorRecord.messages = messages;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigServerSettingsErrorRecord;
        });
    }
}
