// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AcceleratorGitRepository model.
 */
@Fluent
public final class AcceleratorGitRepository implements JsonSerializable<AcceleratorGitRepository> {
    /*
     * Git repository URL for the accelerator.
     */
    private String url;

    /*
     * Interval for checking for updates to Git or image repository.
     */
    private Integer intervalInSeconds;

    /*
     * Git repository branch to be used.
     */
    private String branch;

    /*
     * Git repository commit to be used.
     */
    private String commit;

    /*
     * Git repository tag to be used.
     */
    private String gitTag;

    /*
     * Properties of the auth setting payload.
     */
    private AcceleratorAuthSetting authSetting;

    /*
     * Folder path inside the git repository to consider as the root of the accelerator or fragment.
     */
    private String subPath;

    /**
     * Creates an instance of AcceleratorGitRepository class.
     */
    public AcceleratorGitRepository() {
    }

    /**
     * Get the url property: Git repository URL for the accelerator.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: Git repository URL for the accelerator.
     * 
     * @param url the url value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the intervalInSeconds property: Interval for checking for updates to Git or image repository.
     * 
     * @return the intervalInSeconds value.
     */
    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    /**
     * Set the intervalInSeconds property: Interval for checking for updates to Git or image repository.
     * 
     * @param intervalInSeconds the intervalInSeconds value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    /**
     * Get the branch property: Git repository branch to be used.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch property: Git repository branch to be used.
     * 
     * @param branch the branch value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the commit property: Git repository commit to be used.
     * 
     * @return the commit value.
     */
    public String commit() {
        return this.commit;
    }

    /**
     * Set the commit property: Git repository commit to be used.
     * 
     * @param commit the commit value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    /**
     * Get the gitTag property: Git repository tag to be used.
     * 
     * @return the gitTag value.
     */
    public String gitTag() {
        return this.gitTag;
    }

    /**
     * Set the gitTag property: Git repository tag to be used.
     * 
     * @param gitTag the gitTag value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withGitTag(String gitTag) {
        this.gitTag = gitTag;
        return this;
    }

    /**
     * Get the authSetting property: Properties of the auth setting payload.
     * 
     * @return the authSetting value.
     */
    public AcceleratorAuthSetting authSetting() {
        return this.authSetting;
    }

    /**
     * Set the authSetting property: Properties of the auth setting payload.
     * 
     * @param authSetting the authSetting value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withAuthSetting(AcceleratorAuthSetting authSetting) {
        this.authSetting = authSetting;
        return this;
    }

    /**
     * Get the subPath property: Folder path inside the git repository to consider as the root of the accelerator or
     * fragment.
     * 
     * @return the subPath value.
     */
    public String subPath() {
        return this.subPath;
    }

    /**
     * Set the subPath property: Folder path inside the git repository to consider as the root of the accelerator or
     * fragment.
     * 
     * @param subPath the subPath value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withSubPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property url in model AcceleratorGitRepository"));
        }
        if (authSetting() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property authSetting in model AcceleratorGitRepository"));
        } else {
            authSetting().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorGitRepository.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeJsonField("authSetting", this.authSetting);
        jsonWriter.writeNumberField("intervalInSeconds", this.intervalInSeconds);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("commit", this.commit);
        jsonWriter.writeStringField("gitTag", this.gitTag);
        jsonWriter.writeStringField("subPath", this.subPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcceleratorGitRepository from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcceleratorGitRepository if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcceleratorGitRepository.
     */
    public static AcceleratorGitRepository fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcceleratorGitRepository deserializedAcceleratorGitRepository = new AcceleratorGitRepository();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.url = reader.getString();
                } else if ("authSetting".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.authSetting = AcceleratorAuthSetting.fromJson(reader);
                } else if ("intervalInSeconds".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.intervalInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("branch".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.branch = reader.getString();
                } else if ("commit".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.commit = reader.getString();
                } else if ("gitTag".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.gitTag = reader.getString();
                } else if ("subPath".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.subPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcceleratorGitRepository;
        });
    }
}
