// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Supported server version.
 */
@Fluent
public final class SupportedServerVersionInner implements JsonSerializable<SupportedServerVersionInner> {
    /*
     * The raw server version value which could be passed to deployment CRUD operations.
     */
    private String value;

    /*
     * The server name.
     */
    private String server;

    /*
     * The Server version.
     */
    private String version;

    /**
     * Creates an instance of SupportedServerVersionInner class.
     */
    public SupportedServerVersionInner() {
    }

    /**
     * Get the value property: The raw server version value which could be passed to deployment CRUD operations.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The raw server version value which could be passed to deployment CRUD operations.
     * 
     * @param value the value value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the server property: The server name.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The server name.
     * 
     * @param server the server value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the version property: The Server version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The Server version.
     * 
     * @param version the version value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportedServerVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportedServerVersionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportedServerVersionInner.
     */
    public static SupportedServerVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportedServerVersionInner deserializedSupportedServerVersionInner = new SupportedServerVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSupportedServerVersionInner.value = reader.getString();
                } else if ("server".equals(fieldName)) {
                    deserializedSupportedServerVersionInner.server = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedSupportedServerVersionInner.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportedServerVersionInner;
        });
    }
}
