// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The details of the user-assigned managed identity assigned to an App.
 */
@Immutable
public final class UserAssignedManagedIdentity implements JsonSerializable<UserAssignedManagedIdentity> {
    /*
     * Principal Id of user-assigned managed identity.
     */
    private String principalId;

    /*
     * Client Id of user-assigned managed identity.
     */
    private String clientId;

    /**
     * Creates an instance of UserAssignedManagedIdentity class.
     */
    public UserAssignedManagedIdentity() {
    }

    /**
     * Get the principalId property: Principal Id of user-assigned managed identity.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: Client Id of user-assigned managed identity.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAssignedManagedIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAssignedManagedIdentity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserAssignedManagedIdentity.
     */
    public static UserAssignedManagedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAssignedManagedIdentity deserializedUserAssignedManagedIdentity = new UserAssignedManagedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedUserAssignedManagedIdentity.principalId = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedUserAssignedManagedIdentity.clientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAssignedManagedIdentity;
        });
    }
}
