// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResourceSkuCapabilities model.
 */
@Fluent
public final class ResourceSkuCapabilities implements JsonSerializable<ResourceSkuCapabilities> {
    /*
     * Gets an invariant to describe the feature.
     */
    private String name;

    /*
     * Gets an invariant if the feature is measured by quantity.
     */
    private String value;

    /**
     * Creates an instance of ResourceSkuCapabilities class.
     */
    public ResourceSkuCapabilities() {
    }

    /**
     * Get the name property: Gets an invariant to describe the feature.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Gets an invariant to describe the feature.
     * 
     * @param name the name value to set.
     * @return the ResourceSkuCapabilities object itself.
     */
    public ResourceSkuCapabilities withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Gets an invariant if the feature is measured by quantity.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Gets an invariant if the feature is measured by quantity.
     * 
     * @param value the value value to set.
     * @return the ResourceSkuCapabilities object itself.
     */
    public ResourceSkuCapabilities withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuCapabilities if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuCapabilities.
     */
    public static ResourceSkuCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuCapabilities deserializedResourceSkuCapabilities = new ResourceSkuCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceSkuCapabilities.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedResourceSkuCapabilities.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuCapabilities;
        });
    }
}
