// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to
 * receive traffic.
 */
@Fluent
public final class Probe implements JsonSerializable<Probe> {
    /*
     * The action of the probe.
     */
    private ProbeAction probeAction;

    /*
     * Indicate whether the probe is disabled.
     */
    private boolean disableProbe;

    /*
     * Number of seconds after the App Instance has started before probes are initiated. More info:
     * https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    private Integer initialDelaySeconds;

    /*
     * How often (in seconds) to perform the probe. Minimum value is 1.
     */
    private Integer periodSeconds;

    /*
     * Number of seconds after which the probe times out. Minimum value is 1.
     */
    private Integer timeoutSeconds;

    /*
     * Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
     */
    private Integer failureThreshold;

    /*
     * Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for
     * liveness and startup. Minimum value is 1.
     */
    private Integer successThreshold;

    /**
     * Creates an instance of Probe class.
     */
    public Probe() {
    }

    /**
     * Get the probeAction property: The action of the probe.
     * 
     * @return the probeAction value.
     */
    public ProbeAction probeAction() {
        return this.probeAction;
    }

    /**
     * Set the probeAction property: The action of the probe.
     * 
     * @param probeAction the probeAction value to set.
     * @return the Probe object itself.
     */
    public Probe withProbeAction(ProbeAction probeAction) {
        this.probeAction = probeAction;
        return this;
    }

    /**
     * Get the disableProbe property: Indicate whether the probe is disabled.
     * 
     * @return the disableProbe value.
     */
    public boolean disableProbe() {
        return this.disableProbe;
    }

    /**
     * Set the disableProbe property: Indicate whether the probe is disabled.
     * 
     * @param disableProbe the disableProbe value to set.
     * @return the Probe object itself.
     */
    public Probe withDisableProbe(boolean disableProbe) {
        this.disableProbe = disableProbe;
        return this;
    }

    /**
     * Get the initialDelaySeconds property: Number of seconds after the App Instance has started before probes are
     * initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     * 
     * @return the initialDelaySeconds value.
     */
    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    /**
     * Set the initialDelaySeconds property: Number of seconds after the App Instance has started before probes are
     * initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes.
     * 
     * @param initialDelaySeconds the initialDelaySeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    /**
     * Get the periodSeconds property: How often (in seconds) to perform the probe. Minimum value is 1.
     * 
     * @return the periodSeconds value.
     */
    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    /**
     * Set the periodSeconds property: How often (in seconds) to perform the probe. Minimum value is 1.
     * 
     * @param periodSeconds the periodSeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    /**
     * Get the timeoutSeconds property: Number of seconds after which the probe times out. Minimum value is 1.
     * 
     * @return the timeoutSeconds value.
     */
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    /**
     * Set the timeoutSeconds property: Number of seconds after which the probe times out. Minimum value is 1.
     * 
     * @param timeoutSeconds the timeoutSeconds value to set.
     * @return the Probe object itself.
     */
    public Probe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    /**
     * Get the failureThreshold property: Minimum consecutive failures for the probe to be considered failed after
     * having succeeded. Minimum value is 1.
     * 
     * @return the failureThreshold value.
     */
    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    /**
     * Set the failureThreshold property: Minimum consecutive failures for the probe to be considered failed after
     * having succeeded. Minimum value is 1.
     * 
     * @param failureThreshold the failureThreshold value to set.
     * @return the Probe object itself.
     */
    public Probe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    /**
     * Get the successThreshold property: Minimum consecutive successes for the probe to be considered successful after
     * having failed. Must be 1 for liveness and startup. Minimum value is 1.
     * 
     * @return the successThreshold value.
     */
    public Integer successThreshold() {
        return this.successThreshold;
    }

    /**
     * Set the successThreshold property: Minimum consecutive successes for the probe to be considered successful after
     * having failed. Must be 1 for liveness and startup. Minimum value is 1.
     * 
     * @param successThreshold the successThreshold value to set.
     * @return the Probe object itself.
     */
    public Probe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (probeAction() != null) {
            probeAction().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("disableProbe", this.disableProbe);
        jsonWriter.writeJsonField("probeAction", this.probeAction);
        jsonWriter.writeNumberField("initialDelaySeconds", this.initialDelaySeconds);
        jsonWriter.writeNumberField("periodSeconds", this.periodSeconds);
        jsonWriter.writeNumberField("timeoutSeconds", this.timeoutSeconds);
        jsonWriter.writeNumberField("failureThreshold", this.failureThreshold);
        jsonWriter.writeNumberField("successThreshold", this.successThreshold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Probe from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Probe if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Probe.
     */
    public static Probe fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Probe deserializedProbe = new Probe();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("disableProbe".equals(fieldName)) {
                    deserializedProbe.disableProbe = reader.getBoolean();
                } else if ("probeAction".equals(fieldName)) {
                    deserializedProbe.probeAction = ProbeAction.fromJson(reader);
                } else if ("initialDelaySeconds".equals(fieldName)) {
                    deserializedProbe.initialDelaySeconds = reader.getNullable(JsonReader::getInt);
                } else if ("periodSeconds".equals(fieldName)) {
                    deserializedProbe.periodSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("timeoutSeconds".equals(fieldName)) {
                    deserializedProbe.timeoutSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("failureThreshold".equals(fieldName)) {
                    deserializedProbe.failureThreshold = reader.getNullable(JsonReader::getInt);
                } else if ("successThreshold".equals(fieldName)) {
                    deserializedProbe.successThreshold = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProbe;
        });
    }
}
