// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Uploaded Jar binary for a deployment.
 */
@Fluent
public final class NetCoreZipUploadedUserSourceInfo extends UploadedUserSourceInfo {
    /*
     * Type of the source uploaded
     */
    private String type = "NetCoreZip";

    /*
     * The path to the .NET executable relative to zip root
     */
    private String netCoreMainEntryPath;

    /*
     * Runtime version of the .Net file
     */
    private String runtimeVersion;

    /**
     * Creates an instance of NetCoreZipUploadedUserSourceInfo class.
     */
    public NetCoreZipUploadedUserSourceInfo() {
    }

    /**
     * Get the type property: Type of the source uploaded.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the netCoreMainEntryPath property: The path to the .NET executable relative to zip root.
     * 
     * @return the netCoreMainEntryPath value.
     */
    public String netCoreMainEntryPath() {
        return this.netCoreMainEntryPath;
    }

    /**
     * Set the netCoreMainEntryPath property: The path to the .NET executable relative to zip root.
     * 
     * @param netCoreMainEntryPath the netCoreMainEntryPath value to set.
     * @return the NetCoreZipUploadedUserSourceInfo object itself.
     */
    public NetCoreZipUploadedUserSourceInfo withNetCoreMainEntryPath(String netCoreMainEntryPath) {
        this.netCoreMainEntryPath = netCoreMainEntryPath;
        return this;
    }

    /**
     * Get the runtimeVersion property: Runtime version of the .Net file.
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Runtime version of the .Net file.
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the NetCoreZipUploadedUserSourceInfo object itself.
     */
    public NetCoreZipUploadedUserSourceInfo withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetCoreZipUploadedUserSourceInfo withRelativePath(String relativePath) {
        super.withRelativePath(relativePath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetCoreZipUploadedUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", version());
        jsonWriter.writeStringField("relativePath", relativePath());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("netCoreMainEntryPath", this.netCoreMainEntryPath);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetCoreZipUploadedUserSourceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetCoreZipUploadedUserSourceInfo if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetCoreZipUploadedUserSourceInfo.
     */
    public static NetCoreZipUploadedUserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetCoreZipUploadedUserSourceInfo deserializedNetCoreZipUploadedUserSourceInfo
                = new NetCoreZipUploadedUserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedNetCoreZipUploadedUserSourceInfo.withVersion(reader.getString());
                } else if ("relativePath".equals(fieldName)) {
                    deserializedNetCoreZipUploadedUserSourceInfo.withRelativePath(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedNetCoreZipUploadedUserSourceInfo.type = reader.getString();
                } else if ("netCoreMainEntryPath".equals(fieldName)) {
                    deserializedNetCoreZipUploadedUserSourceInfo.netCoreMainEntryPath = reader.getString();
                } else if ("runtimeVersion".equals(fieldName)) {
                    deserializedNetCoreZipUploadedUserSourceInfo.runtimeVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetCoreZipUploadedUserSourceInfo;
        });
    }
}
