// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Environment variables of Spring Cloud Gateway.
 */
@Fluent
public final class GatewayPropertiesEnvironmentVariables
    implements JsonSerializable<GatewayPropertiesEnvironmentVariables> {
    /*
     * Non-sensitive properties
     */
    private Map<String, String> properties;

    /*
     * Sensitive properties
     */
    private Map<String, String> secrets;

    /**
     * Creates an instance of GatewayPropertiesEnvironmentVariables class.
     */
    public GatewayPropertiesEnvironmentVariables() {
    }

    /**
     * Get the properties property: Non-sensitive properties.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Non-sensitive properties.
     * 
     * @param properties the properties value to set.
     * @return the GatewayPropertiesEnvironmentVariables object itself.
     */
    public GatewayPropertiesEnvironmentVariables withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the secrets property: Sensitive properties.
     * 
     * @return the secrets value.
     */
    public Map<String, String> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Sensitive properties.
     * 
     * @param secrets the secrets value to set.
     * @return the GatewayPropertiesEnvironmentVariables object itself.
     */
    public GatewayPropertiesEnvironmentVariables withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayPropertiesEnvironmentVariables from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayPropertiesEnvironmentVariables if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayPropertiesEnvironmentVariables.
     */
    public static GatewayPropertiesEnvironmentVariables fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayPropertiesEnvironmentVariables deserializedGatewayPropertiesEnvironmentVariables
                = new GatewayPropertiesEnvironmentVariables();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedGatewayPropertiesEnvironmentVariables.properties = properties;
                } else if ("secrets".equals(fieldName)) {
                    Map<String, String> secrets = reader.readMap(reader1 -> reader1.getString());
                    deserializedGatewayPropertiesEnvironmentVariables.secrets = secrets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayPropertiesEnvironmentVariables;
        });
    }
}
