// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The CustomizedAcceleratorResourceCollection model.
 */
@Fluent
public final class CustomizedAcceleratorResourceCollection
    implements JsonSerializable<CustomizedAcceleratorResourceCollection> {
    /*
     * The value property.
     */
    private List<CustomizedAcceleratorResourceInner> value;

    /*
     * The nextLink property.
     */
    private String nextLink;

    /**
     * Creates an instance of CustomizedAcceleratorResourceCollection class.
     */
    public CustomizedAcceleratorResourceCollection() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<CustomizedAcceleratorResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the CustomizedAcceleratorResourceCollection object itself.
     */
    public CustomizedAcceleratorResourceCollection withValue(List<CustomizedAcceleratorResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The nextLink property.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The nextLink property.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CustomizedAcceleratorResourceCollection object itself.
     */
    public CustomizedAcceleratorResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomizedAcceleratorResourceCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomizedAcceleratorResourceCollection if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomizedAcceleratorResourceCollection.
     */
    public static CustomizedAcceleratorResourceCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomizedAcceleratorResourceCollection deserializedCustomizedAcceleratorResourceCollection
                = new CustomizedAcceleratorResourceCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CustomizedAcceleratorResourceInner> value
                        = reader.readArray(reader1 -> CustomizedAcceleratorResourceInner.fromJson(reader1));
                    deserializedCustomizedAcceleratorResourceCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCustomizedAcceleratorResourceCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomizedAcceleratorResourceCollection;
        });
    }
}
