// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The build stage (init-container and container) resources in build pod.
 */
@Immutable
public final class BuildStageProperties implements JsonSerializable<BuildStageProperties> {
    /*
     * The name of this build stage resource.
     */
    private String name;

    /*
     * The provisioning state of this build stage resource.
     */
    private KPackBuildStageProvisioningState status;

    /*
     * The exit code of this build init container.
     */
    private String exitCode;

    /*
     * The reason of this build init container.
     */
    private String reason;

    /**
     * Creates an instance of BuildStageProperties class.
     */
    public BuildStageProperties() {
    }

    /**
     * Get the name property: The name of this build stage resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: The provisioning state of this build stage resource.
     * 
     * @return the status value.
     */
    public KPackBuildStageProvisioningState status() {
        return this.status;
    }

    /**
     * Get the exitCode property: The exit code of this build init container.
     * 
     * @return the exitCode value.
     */
    public String exitCode() {
        return this.exitCode;
    }

    /**
     * Get the reason property: The reason of this build init container.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildStageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildStageProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildStageProperties.
     */
    public static BuildStageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildStageProperties deserializedBuildStageProperties = new BuildStageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedBuildStageProperties.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedBuildStageProperties.status
                        = KPackBuildStageProvisioningState.fromString(reader.getString());
                } else if ("exitCode".equals(fieldName)) {
                    deserializedBuildStageProperties.exitCode = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedBuildStageProperties.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildStageProperties;
        });
    }
}
