// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Build result resource properties payload.
 */
@Fluent
public final class BuildResultProperties implements JsonSerializable<BuildResultProperties> {
    /*
     * The name of this build result
     */
    private String name;

    /*
     * Provisioning state of the KPack build result
     */
    private BuildResultProvisioningState provisioningState;

    /*
     * Error when build is failed.
     */
    private Error error;

    /*
     * The build pod name which can be used to get the build log streaming.
     */
    private String buildPodName;

    /*
     * All of the build stage (init-container and container) resources in build pod.
     */
    private List<BuildStageProperties> buildStages;

    /*
     * The container registry image of this build result.
     */
    private String image;

    /**
     * Creates an instance of BuildResultProperties class.
     */
    public BuildResultProperties() {
    }

    /**
     * Get the name property: The name of this build result.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of this build result.
     * 
     * @param name the name value to set.
     * @return the BuildResultProperties object itself.
     */
    public BuildResultProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the KPack build result.
     * 
     * @return the provisioningState value.
     */
    public BuildResultProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the error property: Error when build is failed.
     * 
     * @return the error value.
     */
    public Error error() {
        return this.error;
    }

    /**
     * Set the error property: Error when build is failed.
     * 
     * @param error the error value to set.
     * @return the BuildResultProperties object itself.
     */
    public BuildResultProperties withError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the buildPodName property: The build pod name which can be used to get the build log streaming.
     * 
     * @return the buildPodName value.
     */
    public String buildPodName() {
        return this.buildPodName;
    }

    /**
     * Set the buildPodName property: The build pod name which can be used to get the build log streaming.
     * 
     * @param buildPodName the buildPodName value to set.
     * @return the BuildResultProperties object itself.
     */
    public BuildResultProperties withBuildPodName(String buildPodName) {
        this.buildPodName = buildPodName;
        return this;
    }

    /**
     * Get the buildStages property: All of the build stage (init-container and container) resources in build pod.
     * 
     * @return the buildStages value.
     */
    public List<BuildStageProperties> buildStages() {
        return this.buildStages;
    }

    /**
     * Get the image property: The container registry image of this build result.
     * 
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
        if (buildStages() != null) {
            buildStages().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("buildPodName", this.buildPodName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildResultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildResultProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildResultProperties.
     */
    public static BuildResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildResultProperties deserializedBuildResultProperties = new BuildResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedBuildResultProperties.name = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBuildResultProperties.provisioningState
                        = BuildResultProvisioningState.fromString(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedBuildResultProperties.error = Error.fromJson(reader);
                } else if ("buildPodName".equals(fieldName)) {
                    deserializedBuildResultProperties.buildPodName = reader.getString();
                } else if ("buildStages".equals(fieldName)) {
                    List<BuildStageProperties> buildStages
                        = reader.readArray(reader1 -> BuildStageProperties.fromJson(reader1));
                    deserializedBuildResultProperties.buildStages = buildStages;
                } else if ("image".equals(fieldName)) {
                    deserializedBuildResultProperties.image = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildResultProperties;
        });
    }
}
