// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application Live View properties payload.
 */
@Immutable
public final class ApplicationLiveViewProperties implements JsonSerializable<ApplicationLiveViewProperties> {
    /*
     * State of the Application Live View.
     */
    private ApplicationLiveViewProvisioningState provisioningState;

    /*
     * Component details of Application Live View
     */
    private List<ApplicationLiveViewComponent> components;

    /**
     * Creates an instance of ApplicationLiveViewProperties class.
     */
    public ApplicationLiveViewProperties() {
    }

    /**
     * Get the provisioningState property: State of the Application Live View.
     * 
     * @return the provisioningState value.
     */
    public ApplicationLiveViewProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the components property: Component details of Application Live View.
     * 
     * @return the components value.
     */
    public List<ApplicationLiveViewComponent> components() {
        return this.components;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationLiveViewProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationLiveViewProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationLiveViewProperties.
     */
    public static ApplicationLiveViewProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationLiveViewProperties deserializedApplicationLiveViewProperties
                = new ApplicationLiveViewProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationLiveViewProperties.provisioningState
                        = ApplicationLiveViewProvisioningState.fromString(reader.getString());
                } else if ("components".equals(fieldName)) {
                    List<ApplicationLiveViewComponent> components
                        = reader.readArray(reader1 -> ApplicationLiveViewComponent.fromJson(reader1));
                    deserializedApplicationLiveViewProperties.components = components;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationLiveViewProperties;
        });
    }
}
