// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Additional App settings in vnet injection instance.
 */
@Fluent
public final class AppVNetAddons implements JsonSerializable<AppVNetAddons> {
    /*
     * Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
     */
    private Boolean publicEndpoint;

    /*
     * URL of the App in vnet injection instance which could be accessed from internet
     */
    private String publicEndpointUrl;

    /**
     * Creates an instance of AppVNetAddons class.
     */
    public AppVNetAddons() {
    }

    /**
     * Get the publicEndpoint property: Indicates whether the App in vnet injection instance exposes endpoint which
     * could be accessed from internet.
     * 
     * @return the publicEndpoint value.
     */
    public Boolean publicEndpoint() {
        return this.publicEndpoint;
    }

    /**
     * Set the publicEndpoint property: Indicates whether the App in vnet injection instance exposes endpoint which
     * could be accessed from internet.
     * 
     * @param publicEndpoint the publicEndpoint value to set.
     * @return the AppVNetAddons object itself.
     */
    public AppVNetAddons withPublicEndpoint(Boolean publicEndpoint) {
        this.publicEndpoint = publicEndpoint;
        return this;
    }

    /**
     * Get the publicEndpointUrl property: URL of the App in vnet injection instance which could be accessed from
     * internet.
     * 
     * @return the publicEndpointUrl value.
     */
    public String publicEndpointUrl() {
        return this.publicEndpointUrl;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("publicEndpoint", this.publicEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppVNetAddons from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppVNetAddons if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppVNetAddons.
     */
    public static AppVNetAddons fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppVNetAddons deserializedAppVNetAddons = new AppVNetAddons();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicEndpoint".equals(fieldName)) {
                    deserializedAppVNetAddons.publicEndpoint = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicEndpointUrl".equals(fieldName)) {
                    deserializedAppVNetAddons.publicEndpointUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppVNetAddons;
        });
    }
}
