// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A list of deployments resource ids.
 */
@Fluent
public final class DeploymentListInner implements JsonSerializable<DeploymentListInner> {
    /*
     * A list of deployment resource ids.
     */
    private List<String> deployments;

    /**
     * Creates an instance of DeploymentListInner class.
     */
    public DeploymentListInner() {
    }

    /**
     * Get the deployments property: A list of deployment resource ids.
     * 
     * @return the deployments value.
     */
    public List<String> deployments() {
        return this.deployments;
    }

    /**
     * Set the deployments property: A list of deployment resource ids.
     * 
     * @param deployments the deployments value to set.
     * @return the DeploymentListInner object itself.
     */
    public DeploymentListInner withDeployments(List<String> deployments) {
        this.deployments = deployments;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("deployments", this.deployments, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentListInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentListInner.
     */
    public static DeploymentListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentListInner deserializedDeploymentListInner = new DeploymentListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deployments".equals(fieldName)) {
                    List<String> deployments = reader.readArray(reader1 -> reader1.getString());
                    deserializedDeploymentListInner.deployments = deployments;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentListInner;
        });
    }
}
