/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ApmReference;
import com.azure.resourcemanager.appplatform.models.ContainerProbeSettings;
import com.azure.resourcemanager.appplatform.models.Probe;
import com.azure.resourcemanager.appplatform.models.ResourceRequests;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DeploymentSettings
implements JsonSerializable<DeploymentSettings> {
    private ResourceRequests resourceRequests;
    private Map<String, String> environmentVariables;
    private List<ApmReference> apms;
    private Map<String, Map<String, Object>> addonConfigs;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private Probe startupProbe;
    private Integer terminationGracePeriodSeconds;
    private ContainerProbeSettings containerProbeSettings;

    public ResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public DeploymentSettings withResourceRequests(ResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public DeploymentSettings withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public List<ApmReference> apms() {
        return this.apms;
    }

    public DeploymentSettings withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    public DeploymentSettings withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    public Probe livenessProbe() {
        return this.livenessProbe;
    }

    public DeploymentSettings withLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public Probe readinessProbe() {
        return this.readinessProbe;
    }

    public DeploymentSettings withReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public Probe startupProbe() {
        return this.startupProbe;
    }

    public DeploymentSettings withStartupProbe(Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    public Integer terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public DeploymentSettings withTerminationGracePeriodSeconds(Integer terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public ContainerProbeSettings containerProbeSettings() {
        return this.containerProbeSettings;
    }

    public DeploymentSettings withContainerProbeSettings(ContainerProbeSettings containerProbeSettings) {
        this.containerProbeSettings = containerProbeSettings;
        return this;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.apms() != null) {
            this.apms().forEach(e -> e.validate());
        }
        if (this.livenessProbe() != null) {
            this.livenessProbe().validate();
        }
        if (this.readinessProbe() != null) {
            this.readinessProbe().validate();
        }
        if (this.startupProbe() != null) {
            this.startupProbe().validate();
        }
        if (this.containerProbeSettings() != null) {
            this.containerProbeSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceRequests", (JsonSerializable)this.resourceRequests);
        jsonWriter.writeMapField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("apms", this.apms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("addonConfigs", this.addonConfigs, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1)));
        jsonWriter.writeJsonField("livenessProbe", (JsonSerializable)this.livenessProbe);
        jsonWriter.writeJsonField("readinessProbe", (JsonSerializable)this.readinessProbe);
        jsonWriter.writeJsonField("startupProbe", (JsonSerializable)this.startupProbe);
        jsonWriter.writeNumberField("terminationGracePeriodSeconds", (Number)this.terminationGracePeriodSeconds);
        jsonWriter.writeJsonField("containerProbeSettings", (JsonSerializable)this.containerProbeSettings);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentSettings)jsonReader.readObject(reader -> {
            DeploymentSettings deserializedDeploymentSettings = new DeploymentSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceRequests".equals(fieldName)) {
                    deserializedDeploymentSettings.resourceRequests = ResourceRequests.fromJson(reader);
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    Map environmentVariables;
                    deserializedDeploymentSettings.environmentVariables = environmentVariables = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("apms".equals(fieldName)) {
                    List apms;
                    deserializedDeploymentSettings.apms = apms = reader.readArray(reader1 -> ApmReference.fromJson(reader1));
                    continue;
                }
                if ("addonConfigs".equals(fieldName)) {
                    Map addonConfigs;
                    deserializedDeploymentSettings.addonConfigs = addonConfigs = reader.readMap(reader1 -> reader1.readMap(reader2 -> reader2.readUntyped()));
                    continue;
                }
                if ("livenessProbe".equals(fieldName)) {
                    deserializedDeploymentSettings.livenessProbe = Probe.fromJson(reader);
                    continue;
                }
                if ("readinessProbe".equals(fieldName)) {
                    deserializedDeploymentSettings.readinessProbe = Probe.fromJson(reader);
                    continue;
                }
                if ("startupProbe".equals(fieldName)) {
                    deserializedDeploymentSettings.startupProbe = Probe.fromJson(reader);
                    continue;
                }
                if ("terminationGracePeriodSeconds".equals(fieldName)) {
                    deserializedDeploymentSettings.terminationGracePeriodSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerProbeSettings".equals(fieldName)) {
                    deserializedDeploymentSettings.containerProbeSettings = ContainerProbeSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentSettings;
        });
    }
}

