// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of instances belong to the Spring Cloud Gateway.
 */
@Immutable
public final class GatewayInstance implements JsonSerializable<GatewayInstance> {
    /*
     * Name of the Spring Cloud Gateway instance
     */
    private String name;

    /*
     * Status of the Spring Cloud Gateway instance
     */
    private String status;

    /**
     * Creates an instance of GatewayInstance class.
     */
    public GatewayInstance() {
    }

    /**
     * Get the name property: Name of the Spring Cloud Gateway instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the Spring Cloud Gateway instance.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayInstance if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayInstance.
     */
    public static GatewayInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayInstance deserializedGatewayInstance = new GatewayInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGatewayInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedGatewayInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayInstance;
        });
    }
}
