// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Property of git environment.
 */
@Fluent
public final class ConfigurationServiceGitProperty implements JsonSerializable<ConfigurationServiceGitProperty> {
    /*
     * Repositories of Application Configuration Service git property.
     */
    private List<ConfigurationServiceGitRepository> repositories;

    /**
     * Creates an instance of ConfigurationServiceGitProperty class.
     */
    public ConfigurationServiceGitProperty() {
    }

    /**
     * Get the repositories property: Repositories of Application Configuration Service git property.
     * 
     * @return the repositories value.
     */
    public List<ConfigurationServiceGitRepository> repositories() {
        return this.repositories;
    }

    /**
     * Set the repositories property: Repositories of Application Configuration Service git property.
     * 
     * @param repositories the repositories value to set.
     * @return the ConfigurationServiceGitProperty object itself.
     */
    public ConfigurationServiceGitProperty withRepositories(List<ConfigurationServiceGitRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (repositories() != null) {
            repositories().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("repositories", this.repositories, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationServiceGitProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationServiceGitProperty if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationServiceGitProperty.
     */
    public static ConfigurationServiceGitProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationServiceGitProperty deserializedConfigurationServiceGitProperty
                = new ConfigurationServiceGitProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("repositories".equals(fieldName)) {
                    List<ConfigurationServiceGitRepository> repositories
                        = reader.readArray(reader1 -> ConfigurationServiceGitRepository.fromJson(reader1));
                    deserializedConfigurationServiceGitProperty.repositories = repositories;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationServiceGitProperty;
        });
    }
}
