// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Buildpack properties payload.
 */
@Fluent
public final class BuildpackProperties implements JsonSerializable<BuildpackProperties> {
    /*
     * Id of the buildpack
     */
    private String id;

    /**
     * Creates an instance of BuildpackProperties class.
     */
    public BuildpackProperties() {
    }

    /**
     * Get the id property: Id of the buildpack.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Id of the buildpack.
     * 
     * @param id the id value to set.
     * @return the BuildpackProperties object itself.
     */
    public BuildpackProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildpackProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildpackProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildpackProperties.
     */
    public static BuildpackProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildpackProperties deserializedBuildpackProperties = new BuildpackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBuildpackProperties.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildpackProperties;
        });
    }
}
