// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Uploaded War binary for a deployment.
 */
@Fluent
public final class WarUploadedUserSourceInfo extends UploadedUserSourceInfo {
    /*
     * Type of the source uploaded
     */
    private String type = "War";

    /*
     * Runtime version of the war file
     */
    private String runtimeVersion;

    /*
     * JVM parameter
     */
    private String jvmOptions;

    /*
     * Server version, currently only Apache Tomcat is supported
     */
    private String serverVersion;

    /**
     * Creates an instance of WarUploadedUserSourceInfo class.
     */
    public WarUploadedUserSourceInfo() {
    }

    /**
     * Get the type property: Type of the source uploaded.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the runtimeVersion property: Runtime version of the war file.
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Runtime version of the war file.
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the jvmOptions property: JVM parameter.
     * 
     * @return the jvmOptions value.
     */
    public String jvmOptions() {
        return this.jvmOptions;
    }

    /**
     * Set the jvmOptions property: JVM parameter.
     * 
     * @param jvmOptions the jvmOptions value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    /**
     * Get the serverVersion property: Server version, currently only Apache Tomcat is supported.
     * 
     * @return the serverVersion value.
     */
    public String serverVersion() {
        return this.serverVersion;
    }

    /**
     * Set the serverVersion property: Server version, currently only Apache Tomcat is supported.
     * 
     * @param serverVersion the serverVersion value to set.
     * @return the WarUploadedUserSourceInfo object itself.
     */
    public WarUploadedUserSourceInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WarUploadedUserSourceInfo withRelativePath(String relativePath) {
        super.withRelativePath(relativePath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WarUploadedUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", version());
        jsonWriter.writeStringField("relativePath", relativePath());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        jsonWriter.writeStringField("jvmOptions", this.jvmOptions);
        jsonWriter.writeStringField("serverVersion", this.serverVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WarUploadedUserSourceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WarUploadedUserSourceInfo if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WarUploadedUserSourceInfo.
     */
    public static WarUploadedUserSourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WarUploadedUserSourceInfo deserializedWarUploadedUserSourceInfo = new WarUploadedUserSourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.withVersion(reader.getString());
                } else if ("relativePath".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.withRelativePath(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.type = reader.getString();
                } else if ("runtimeVersion".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.runtimeVersion = reader.getString();
                } else if ("jvmOptions".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.jvmOptions = reader.getString();
                } else if ("serverVersion".equals(fieldName)) {
                    deserializedWarUploadedUserSourceInfo.serverVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWarUploadedUserSourceInfo;
        });
    }
}
