// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Service Registry properties payload.
 */
@Immutable
public final class ServiceRegistryProperties implements JsonSerializable<ServiceRegistryProperties> {
    /*
     * State of the Service Registry.
     */
    private ServiceRegistryProvisioningState provisioningState;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    private ServiceRegistryResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Service Registry.
     */
    private List<ServiceRegistryInstance> instances;

    /**
     * Creates an instance of ServiceRegistryProperties class.
     */
    public ServiceRegistryProperties() {
    }

    /**
     * Get the provisioningState property: State of the Service Registry.
     * 
     * @return the provisioningState value.
     */
    public ServiceRegistryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public ServiceRegistryResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Service Registry.
     * 
     * @return the instances value.
     */
    public List<ServiceRegistryInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceRegistryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceRegistryProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceRegistryProperties.
     */
    public static ServiceRegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceRegistryProperties deserializedServiceRegistryProperties = new ServiceRegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedServiceRegistryProperties.provisioningState
                        = ServiceRegistryProvisioningState.fromString(reader.getString());
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedServiceRegistryProperties.resourceRequests
                        = ServiceRegistryResourceRequests.fromJson(reader);
                } else if ("instances".equals(fieldName)) {
                    List<ServiceRegistryInstance> instances
                        = reader.readArray(reader1 -> ServiceRegistryInstance.fromJson(reader1));
                    deserializedServiceRegistryProperties.instances = instances;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceRegistryProperties;
        });
    }
}
