// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * App ingress settings payload.
 */
@Fluent
public final class IngressSettings implements JsonSerializable<IngressSettings> {
    /*
     * Ingress read time out in seconds.
     */
    private Integer readTimeoutInSeconds;

    /*
     * Ingress send time out in seconds.
     */
    private Integer sendTimeoutInSeconds;

    /*
     * Type of the affinity, set this to Cookie to enable session affinity.
     */
    private SessionAffinity sessionAffinity;

    /*
     * Time in seconds until the cookie expires.
     */
    private Integer sessionCookieMaxAge;

    /*
     * How ingress should communicate with this app backend service.
     */
    private BackendProtocol backendProtocol;

    /*
     * Client-Certification Authentication.
     */
    private IngressSettingsClientAuth clientAuth;

    /**
     * Creates an instance of IngressSettings class.
     */
    public IngressSettings() {
    }

    /**
     * Get the readTimeoutInSeconds property: Ingress read time out in seconds.
     * 
     * @return the readTimeoutInSeconds value.
     */
    public Integer readTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    /**
     * Set the readTimeoutInSeconds property: Ingress read time out in seconds.
     * 
     * @param readTimeoutInSeconds the readTimeoutInSeconds value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withReadTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    /**
     * Get the sendTimeoutInSeconds property: Ingress send time out in seconds.
     * 
     * @return the sendTimeoutInSeconds value.
     */
    public Integer sendTimeoutInSeconds() {
        return this.sendTimeoutInSeconds;
    }

    /**
     * Set the sendTimeoutInSeconds property: Ingress send time out in seconds.
     * 
     * @param sendTimeoutInSeconds the sendTimeoutInSeconds value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSendTimeoutInSeconds(Integer sendTimeoutInSeconds) {
        this.sendTimeoutInSeconds = sendTimeoutInSeconds;
        return this;
    }

    /**
     * Get the sessionAffinity property: Type of the affinity, set this to Cookie to enable session affinity.
     * 
     * @return the sessionAffinity value.
     */
    public SessionAffinity sessionAffinity() {
        return this.sessionAffinity;
    }

    /**
     * Set the sessionAffinity property: Type of the affinity, set this to Cookie to enable session affinity.
     * 
     * @param sessionAffinity the sessionAffinity value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSessionAffinity(SessionAffinity sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return this;
    }

    /**
     * Get the sessionCookieMaxAge property: Time in seconds until the cookie expires.
     * 
     * @return the sessionCookieMaxAge value.
     */
    public Integer sessionCookieMaxAge() {
        return this.sessionCookieMaxAge;
    }

    /**
     * Set the sessionCookieMaxAge property: Time in seconds until the cookie expires.
     * 
     * @param sessionCookieMaxAge the sessionCookieMaxAge value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withSessionCookieMaxAge(Integer sessionCookieMaxAge) {
        this.sessionCookieMaxAge = sessionCookieMaxAge;
        return this;
    }

    /**
     * Get the backendProtocol property: How ingress should communicate with this app backend service.
     * 
     * @return the backendProtocol value.
     */
    public BackendProtocol backendProtocol() {
        return this.backendProtocol;
    }

    /**
     * Set the backendProtocol property: How ingress should communicate with this app backend service.
     * 
     * @param backendProtocol the backendProtocol value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withBackendProtocol(BackendProtocol backendProtocol) {
        this.backendProtocol = backendProtocol;
        return this;
    }

    /**
     * Get the clientAuth property: Client-Certification Authentication.
     * 
     * @return the clientAuth value.
     */
    public IngressSettingsClientAuth clientAuth() {
        return this.clientAuth;
    }

    /**
     * Set the clientAuth property: Client-Certification Authentication.
     * 
     * @param clientAuth the clientAuth value to set.
     * @return the IngressSettings object itself.
     */
    public IngressSettings withClientAuth(IngressSettingsClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (clientAuth() != null) {
            clientAuth().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("readTimeoutInSeconds", this.readTimeoutInSeconds);
        jsonWriter.writeNumberField("sendTimeoutInSeconds", this.sendTimeoutInSeconds);
        jsonWriter.writeStringField("sessionAffinity",
            this.sessionAffinity == null ? null : this.sessionAffinity.toString());
        jsonWriter.writeNumberField("sessionCookieMaxAge", this.sessionCookieMaxAge);
        jsonWriter.writeStringField("backendProtocol",
            this.backendProtocol == null ? null : this.backendProtocol.toString());
        jsonWriter.writeJsonField("clientAuth", this.clientAuth);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IngressSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IngressSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IngressSettings.
     */
    public static IngressSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IngressSettings deserializedIngressSettings = new IngressSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("readTimeoutInSeconds".equals(fieldName)) {
                    deserializedIngressSettings.readTimeoutInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("sendTimeoutInSeconds".equals(fieldName)) {
                    deserializedIngressSettings.sendTimeoutInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("sessionAffinity".equals(fieldName)) {
                    deserializedIngressSettings.sessionAffinity = SessionAffinity.fromString(reader.getString());
                } else if ("sessionCookieMaxAge".equals(fieldName)) {
                    deserializedIngressSettings.sessionCookieMaxAge = reader.getNullable(JsonReader::getInt);
                } else if ("backendProtocol".equals(fieldName)) {
                    deserializedIngressSettings.backendProtocol = BackendProtocol.fromString(reader.getString());
                } else if ("clientAuth".equals(fieldName)) {
                    deserializedIngressSettings.clientAuth = IngressSettingsClientAuth.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIngressSettings;
        });
    }
}
