// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Build resource properties payload.
 */
@Fluent
public final class BuildProperties implements JsonSerializable<BuildProperties> {
    /*
     * The relative path of source code
     */
    private String relativePath;

    /*
     * The resource id of builder to build the source code
     */
    private String builder;

    /*
     * The resource id of agent pool
     */
    private String agentPool;

    /*
     * Provisioning state of the KPack build result
     */
    private BuildProvisioningState provisioningState;

    /*
     * The environment variables for this build
     */
    private Map<String, String> env;

    /*
     * The APMs for this build
     */
    private List<ApmReference> apms;

    /*
     * The CA Certificates for this build
     */
    private List<CertificateReference> certificates;

    /*
     * The build result triggered by this build
     */
    private TriggeredBuildResult triggeredBuildResult;

    /*
     * The customized build resource for this build
     */
    private BuildResourceRequests resourceRequests;

    /**
     * Creates an instance of BuildProperties class.
     */
    public BuildProperties() {
    }

    /**
     * Get the relativePath property: The relative path of source code.
     * 
     * @return the relativePath value.
     */
    public String relativePath() {
        return this.relativePath;
    }

    /**
     * Set the relativePath property: The relative path of source code.
     * 
     * @param relativePath the relativePath value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    /**
     * Get the builder property: The resource id of builder to build the source code.
     * 
     * @return the builder value.
     */
    public String builder() {
        return this.builder;
    }

    /**
     * Set the builder property: The resource id of builder to build the source code.
     * 
     * @param builder the builder value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withBuilder(String builder) {
        this.builder = builder;
        return this;
    }

    /**
     * Get the agentPool property: The resource id of agent pool.
     * 
     * @return the agentPool value.
     */
    public String agentPool() {
        return this.agentPool;
    }

    /**
     * Set the agentPool property: The resource id of agent pool.
     * 
     * @param agentPool the agentPool value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withAgentPool(String agentPool) {
        this.agentPool = agentPool;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the KPack build result.
     * 
     * @return the provisioningState value.
     */
    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the env property: The environment variables for this build.
     * 
     * @return the env value.
     */
    public Map<String, String> env() {
        return this.env;
    }

    /**
     * Set the env property: The environment variables for this build.
     * 
     * @param env the env value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    /**
     * Get the apms property: The APMs for this build.
     * 
     * @return the apms value.
     */
    public List<ApmReference> apms() {
        return this.apms;
    }

    /**
     * Set the apms property: The APMs for this build.
     * 
     * @param apms the apms value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    /**
     * Get the certificates property: The CA Certificates for this build.
     * 
     * @return the certificates value.
     */
    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: The CA Certificates for this build.
     * 
     * @param certificates the certificates value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the triggeredBuildResult property: The build result triggered by this build.
     * 
     * @return the triggeredBuildResult value.
     */
    public TriggeredBuildResult triggeredBuildResult() {
        return this.triggeredBuildResult;
    }

    /**
     * Get the resourceRequests property: The customized build resource for this build.
     * 
     * @return the resourceRequests value.
     */
    public BuildResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The customized build resource for this build.
     * 
     * @param resourceRequests the resourceRequests value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withResourceRequests(BuildResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (apms() != null) {
            apms().forEach(e -> e.validate());
        }
        if (certificates() != null) {
            certificates().forEach(e -> e.validate());
        }
        if (triggeredBuildResult() != null) {
            triggeredBuildResult().validate();
        }
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relativePath", this.relativePath);
        jsonWriter.writeStringField("builder", this.builder);
        jsonWriter.writeStringField("agentPool", this.agentPool);
        jsonWriter.writeMapField("env", this.env, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("apms", this.apms, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("resourceRequests", this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildProperties.
     */
    public static BuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildProperties deserializedBuildProperties = new BuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("relativePath".equals(fieldName)) {
                    deserializedBuildProperties.relativePath = reader.getString();
                } else if ("builder".equals(fieldName)) {
                    deserializedBuildProperties.builder = reader.getString();
                } else if ("agentPool".equals(fieldName)) {
                    deserializedBuildProperties.agentPool = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBuildProperties.provisioningState
                        = BuildProvisioningState.fromString(reader.getString());
                } else if ("env".equals(fieldName)) {
                    Map<String, String> env = reader.readMap(reader1 -> reader1.getString());
                    deserializedBuildProperties.env = env;
                } else if ("apms".equals(fieldName)) {
                    List<ApmReference> apms = reader.readArray(reader1 -> ApmReference.fromJson(reader1));
                    deserializedBuildProperties.apms = apms;
                } else if ("certificates".equals(fieldName)) {
                    List<CertificateReference> certificates
                        = reader.readArray(reader1 -> CertificateReference.fromJson(reader1));
                    deserializedBuildProperties.certificates = certificates;
                } else if ("triggeredBuildResult".equals(fieldName)) {
                    deserializedBuildProperties.triggeredBuildResult = TriggeredBuildResult.fromJson(reader);
                } else if ("resourceRequests".equals(fieldName)) {
                    deserializedBuildProperties.resourceRequests = BuildResourceRequests.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildProperties;
        });
    }
}
