/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.CertificateProperties;
import com.azure.resourcemanager.appplatform.models.CertificateResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.KeyVaultCertificateAutoSync;
import java.io.IOException;
import java.util.List;

public final class KeyVaultCertificateProperties
extends CertificateProperties {
    private String type = "KeyVaultCertificate";
    private String vaultUri;
    private String keyVaultCertName;
    private String certVersion;
    private Boolean excludePrivateKey;
    private KeyVaultCertificateAutoSync autoSync;
    private String thumbprint;
    private String issuer;
    private String issuedDate;
    private String expirationDate;
    private String activateDate;
    private String subjectName;
    private List<String> dnsNames;
    private CertificateResourceProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultCertificateProperties.class);

    @Override
    public String type() {
        return this.type;
    }

    public String vaultUri() {
        return this.vaultUri;
    }

    public KeyVaultCertificateProperties withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    public String keyVaultCertName() {
        return this.keyVaultCertName;
    }

    public KeyVaultCertificateProperties withKeyVaultCertName(String keyVaultCertName) {
        this.keyVaultCertName = keyVaultCertName;
        return this;
    }

    public String certVersion() {
        return this.certVersion;
    }

    public KeyVaultCertificateProperties withCertVersion(String certVersion) {
        this.certVersion = certVersion;
        return this;
    }

    public Boolean excludePrivateKey() {
        return this.excludePrivateKey;
    }

    public KeyVaultCertificateProperties withExcludePrivateKey(Boolean excludePrivateKey) {
        this.excludePrivateKey = excludePrivateKey;
        return this;
    }

    public KeyVaultCertificateAutoSync autoSync() {
        return this.autoSync;
    }

    public KeyVaultCertificateProperties withAutoSync(KeyVaultCertificateAutoSync autoSync) {
        this.autoSync = autoSync;
        return this;
    }

    @Override
    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public String issuer() {
        return this.issuer;
    }

    @Override
    public String issuedDate() {
        return this.issuedDate;
    }

    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    @Override
    public String activateDate() {
        return this.activateDate;
    }

    @Override
    public String subjectName() {
        return this.subjectName;
    }

    @Override
    public List<String> dnsNames() {
        return this.dnsNames;
    }

    @Override
    public CertificateResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.vaultUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vaultUri in model KeyVaultCertificateProperties"));
        }
        if (this.keyVaultCertName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultCertName in model KeyVaultCertificateProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vaultUri", this.vaultUri);
        jsonWriter.writeStringField("keyVaultCertName", this.keyVaultCertName);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("certVersion", this.certVersion);
        jsonWriter.writeBooleanField("excludePrivateKey", this.excludePrivateKey);
        jsonWriter.writeStringField("autoSync", this.autoSync == null ? null : this.autoSync.toString());
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultCertificateProperties)jsonReader.readObject(reader -> {
            KeyVaultCertificateProperties deserializedKeyVaultCertificateProperties = new KeyVaultCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprint".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.issuer = reader.getString();
                    continue;
                }
                if ("issuedDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.issuedDate = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.expirationDate = reader.getString();
                    continue;
                }
                if ("activateDate".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.activateDate = reader.getString();
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.subjectName = reader.getString();
                    continue;
                }
                if ("dnsNames".equals(fieldName)) {
                    List dnsNames;
                    deserializedKeyVaultCertificateProperties.dnsNames = dnsNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.provisioningState = CertificateResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("vaultUri".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.vaultUri = reader.getString();
                    continue;
                }
                if ("keyVaultCertName".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.keyVaultCertName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.type = reader.getString();
                    continue;
                }
                if ("certVersion".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.certVersion = reader.getString();
                    continue;
                }
                if ("excludePrivateKey".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.excludePrivateKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoSync".equals(fieldName)) {
                    deserializedKeyVaultCertificateProperties.autoSync = KeyVaultCertificateAutoSync.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultCertificateProperties;
        });
    }
}

