// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Supported buildpack resource properties.
 */
@Fluent
public final class SupportedBuildpackResourceProperties
    implements JsonSerializable<SupportedBuildpackResourceProperties> {
    /*
     * The id of supported buildpack
     */
    private String buildpackId;

    /**
     * Creates an instance of SupportedBuildpackResourceProperties class.
     */
    public SupportedBuildpackResourceProperties() {
    }

    /**
     * Get the buildpackId property: The id of supported buildpack.
     * 
     * @return the buildpackId value.
     */
    public String buildpackId() {
        return this.buildpackId;
    }

    /**
     * Set the buildpackId property: The id of supported buildpack.
     * 
     * @param buildpackId the buildpackId value to set.
     * @return the SupportedBuildpackResourceProperties object itself.
     */
    public SupportedBuildpackResourceProperties withBuildpackId(String buildpackId) {
        this.buildpackId = buildpackId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("buildpackId", this.buildpackId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportedBuildpackResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportedBuildpackResourceProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportedBuildpackResourceProperties.
     */
    public static SupportedBuildpackResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportedBuildpackResourceProperties deserializedSupportedBuildpackResourceProperties
                = new SupportedBuildpackResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("buildpackId".equals(fieldName)) {
                    deserializedSupportedBuildpackResourceProperties.buildpackId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportedBuildpackResourceProperties;
        });
    }
}
