// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Persistent disk payload.
 */
@Fluent
public final class PersistentDisk implements JsonSerializable<PersistentDisk> {
    /*
     * Size of the persistent disk in GB
     */
    private Integer sizeInGB;

    /*
     * Size of the used persistent disk in GB
     */
    private Integer usedInGB;

    /*
     * Mount path of the persistent disk
     */
    private String mountPath;

    /**
     * Creates an instance of PersistentDisk class.
     */
    public PersistentDisk() {
    }

    /**
     * Get the sizeInGB property: Size of the persistent disk in GB.
     * 
     * @return the sizeInGB value.
     */
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    /**
     * Set the sizeInGB property: Size of the persistent disk in GB.
     * 
     * @param sizeInGB the sizeInGB value to set.
     * @return the PersistentDisk object itself.
     */
    public PersistentDisk withSizeInGB(Integer sizeInGB) {
        this.sizeInGB = sizeInGB;
        return this;
    }

    /**
     * Get the usedInGB property: Size of the used persistent disk in GB.
     * 
     * @return the usedInGB value.
     */
    public Integer usedInGB() {
        return this.usedInGB;
    }

    /**
     * Get the mountPath property: Mount path of the persistent disk.
     * 
     * @return the mountPath value.
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath property: Mount path of the persistent disk.
     * 
     * @param mountPath the mountPath value to set.
     * @return the PersistentDisk object itself.
     */
    public PersistentDisk withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sizeInGB", this.sizeInGB);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PersistentDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PersistentDisk if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PersistentDisk.
     */
    public static PersistentDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PersistentDisk deserializedPersistentDisk = new PersistentDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sizeInGB".equals(fieldName)) {
                    deserializedPersistentDisk.sizeInGB = reader.getNullable(JsonReader::getInt);
                } else if ("usedInGB".equals(fieldName)) {
                    deserializedPersistentDisk.usedInGB = reader.getNullable(JsonReader::getInt);
                } else if ("mountPath".equals(fieldName)) {
                    deserializedPersistentDisk.mountPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPersistentDisk;
        });
    }
}
