// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 */
@Fluent
public final class HttpGetAction extends ProbeAction {
    /*
     * The type of the action to take to perform the health check.
     */
    private ProbeActionType type = ProbeActionType.HTTPGET_ACTION;

    /*
     * Path to access on the HTTP server.
     */
    private String path;

    /*
     * Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://
     */
    private HttpSchemeType scheme;

    /**
     * Creates an instance of HttpGetAction class.
     */
    public HttpGetAction() {
    }

    /**
     * Get the type property: The type of the action to take to perform the health check.
     * 
     * @return the type value.
     */
    @Override
    public ProbeActionType type() {
        return this.type;
    }

    /**
     * Get the path property: Path to access on the HTTP server.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Path to access on the HTTP server.
     * 
     * @param path the path value to set.
     * @return the HttpGetAction object itself.
     */
    public HttpGetAction withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the scheme property: Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://.
     * 
     * @return the scheme value.
     */
    public HttpSchemeType scheme() {
        return this.scheme;
    }

    /**
     * Set the scheme property: Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://.
     * 
     * @param scheme the scheme value to set.
     * @return the HttpGetAction object itself.
     */
    public HttpGetAction withScheme(HttpSchemeType scheme) {
        this.scheme = scheme;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("scheme", this.scheme == null ? null : this.scheme.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpGetAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpGetAction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpGetAction.
     */
    public static HttpGetAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpGetAction deserializedHttpGetAction = new HttpGetAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedHttpGetAction.type = ProbeActionType.fromString(reader.getString());
                } else if ("path".equals(fieldName)) {
                    deserializedHttpGetAction.path = reader.getString();
                } else if ("scheme".equals(fieldName)) {
                    deserializedHttpGetAction.scheme = HttpSchemeType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpGetAction;
        });
    }
}
