// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A reference to the certificate.
 */
@Fluent
public final class CertificateReference implements JsonSerializable<CertificateReference> {
    /*
     * Resource Id of the certificate
     */
    private String resourceId;

    /**
     * Creates an instance of CertificateReference class.
     */
    public CertificateReference() {
    }

    /**
     * Get the resourceId property: Resource Id of the certificate.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource Id of the certificate.
     * 
     * @param resourceId the resourceId value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceId() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property resourceId in model CertificateReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CertificateReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateReference.
     */
    public static CertificateReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateReference deserializedCertificateReference = new CertificateReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedCertificateReference.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateReference;
        });
    }
}
