// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The runtime resource configuration of this build service.
 */
@Immutable
public final class BuildServicePropertiesResourceRequests
    implements JsonSerializable<BuildServicePropertiesResourceRequests> {
    /*
     * vCPU allocated to the entire build service node pool.
     */
    private String cpu;

    /*
     * Memory allocated to the entire build service node pool.
     */
    private String memory;

    /**
     * Creates an instance of BuildServicePropertiesResourceRequests class.
     */
    public BuildServicePropertiesResourceRequests() {
    }

    /**
     * Get the cpu property: vCPU allocated to the entire build service node pool.
     * 
     * @return the cpu value.
     */
    public String cpu() {
        return this.cpu;
    }

    /**
     * Get the memory property: Memory allocated to the entire build service node pool.
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildServicePropertiesResourceRequests from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildServicePropertiesResourceRequests if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildServicePropertiesResourceRequests.
     */
    public static BuildServicePropertiesResourceRequests fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildServicePropertiesResourceRequests deserializedBuildServicePropertiesResourceRequests
                = new BuildServicePropertiesResourceRequests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedBuildServicePropertiesResourceRequests.cpu = reader.getString();
                } else if ("memory".equals(fieldName)) {
                    deserializedBuildServicePropertiesResourceRequests.memory = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildServicePropertiesResourceRequests;
        });
    }
}
