// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Test keys payload.
 */
@Fluent
public final class TestKeys implements JsonSerializable<TestKeys> {
    /*
     * Primary key
     */
    private String primaryKey;

    /*
     * Secondary key
     */
    private String secondaryKey;

    /*
     * Primary test endpoint
     */
    private String primaryTestEndpoint;

    /*
     * Secondary test endpoint
     */
    private String secondaryTestEndpoint;

    /*
     * Indicates whether the test endpoint feature enabled or not
     */
    private Boolean enabled;

    /**
     * Creates an instance of TestKeys class.
     */
    public TestKeys() {
    }

    /**
     * Get the primaryKey property: Primary key.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Primary key.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary key.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Secondary key.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the primaryTestEndpoint property: Primary test endpoint.
     * 
     * @return the primaryTestEndpoint value.
     */
    public String primaryTestEndpoint() {
        return this.primaryTestEndpoint;
    }

    /**
     * Set the primaryTestEndpoint property: Primary test endpoint.
     * 
     * @param primaryTestEndpoint the primaryTestEndpoint value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withPrimaryTestEndpoint(String primaryTestEndpoint) {
        this.primaryTestEndpoint = primaryTestEndpoint;
        return this;
    }

    /**
     * Get the secondaryTestEndpoint property: Secondary test endpoint.
     * 
     * @return the secondaryTestEndpoint value.
     */
    public String secondaryTestEndpoint() {
        return this.secondaryTestEndpoint;
    }

    /**
     * Set the secondaryTestEndpoint property: Secondary test endpoint.
     * 
     * @param secondaryTestEndpoint the secondaryTestEndpoint value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withSecondaryTestEndpoint(String secondaryTestEndpoint) {
        this.secondaryTestEndpoint = secondaryTestEndpoint;
        return this;
    }

    /**
     * Get the enabled property: Indicates whether the test endpoint feature enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether the test endpoint feature enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("primaryTestEndpoint", this.primaryTestEndpoint);
        jsonWriter.writeStringField("secondaryTestEndpoint", this.secondaryTestEndpoint);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TestKeys from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TestKeys if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the TestKeys.
     */
    public static TestKeys fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TestKeys deserializedTestKeys = new TestKeys();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryKey".equals(fieldName)) {
                    deserializedTestKeys.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedTestKeys.secondaryKey = reader.getString();
                } else if ("primaryTestEndpoint".equals(fieldName)) {
                    deserializedTestKeys.primaryTestEndpoint = reader.getString();
                } else if ("secondaryTestEndpoint".equals(fieldName)) {
                    deserializedTestKeys.secondaryTestEndpoint = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedTestKeys.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTestKeys;
        });
    }
}
