// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of instances belong to the Service Registry.
 */
@Immutable
public final class ServiceRegistryInstance implements JsonSerializable<ServiceRegistryInstance> {
    /*
     * Name of the Service Registry instance
     */
    private String name;

    /*
     * Status of the Service Registry instance
     */
    private String status;

    /**
     * Creates an instance of ServiceRegistryInstance class.
     */
    public ServiceRegistryInstance() {
    }

    /**
     * Get the name property: Name of the Service Registry instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the Service Registry instance.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceRegistryInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceRegistryInstance if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceRegistryInstance.
     */
    public static ServiceRegistryInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceRegistryInstance deserializedServiceRegistryInstance = new ServiceRegistryInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedServiceRegistryInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedServiceRegistryInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceRegistryInstance;
        });
    }
}
