// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of instances belong to the Dev Tool Portal.
 */
@Immutable
public final class DevToolPortalInstance implements JsonSerializable<DevToolPortalInstance> {
    /*
     * Name of the Dev Tool Portal instance.
     */
    private String name;

    /*
     * Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded, Failed, Unknown.
     */
    private String status;

    /**
     * Creates an instance of DevToolPortalInstance class.
     */
    public DevToolPortalInstance() {
    }

    /**
     * Get the name property: Name of the Dev Tool Portal instance.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded, Failed,
     * Unknown.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DevToolPortalInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DevToolPortalInstance if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DevToolPortalInstance.
     */
    public static DevToolPortalInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DevToolPortalInstance deserializedDevToolPortalInstance = new DevToolPortalInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDevToolPortalInstance.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedDevToolPortalInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDevToolPortalInstance;
        });
    }
}
