// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorValidateResultInner;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorProperties;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CustomizedAcceleratorsClient.
 */
public interface CustomizedAcceleratorsClient {
    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CustomizedAcceleratorResourceInner> listAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName);

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CustomizedAcceleratorResourceInner> list(String resourceGroupName, String serviceName,
        String applicationAcceleratorName);

    /**
     * Handle requests to list all customized accelerators.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CustomizedAcceleratorResourceInner> list(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, Context context);

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomizedAcceleratorResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomizedAcceleratorResourceInner> getAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomizedAcceleratorResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context);

    /**
     * Get the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the customized accelerator.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomizedAcceleratorResourceInner get(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CustomizedAcceleratorResourceInner>, CustomizedAcceleratorResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName, CustomizedAcceleratorResourceInner customizedAcceleratorResource,
        Context context);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomizedAcceleratorResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomizedAcceleratorResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource);

    /**
     * Create or update the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param customizedAcceleratorResource The customized accelerator for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return customized accelerator resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomizedAcceleratorResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorResourceInner customizedAcceleratorResource, Context context);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, Context context);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName);

    /**
     * Delete the customized accelerator.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String applicationAcceleratorName,
        String customizedAcceleratorName, Context context);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidateAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CustomizedAcceleratorValidateResultInner>, CustomizedAcceleratorValidateResultInner>
        beginValidate(String resourceGroupName, String serviceName, String applicationAcceleratorName,
            String customizedAcceleratorName, CustomizedAcceleratorProperties properties, Context context);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomizedAcceleratorValidateResultInner> validateAsync(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomizedAcceleratorValidateResultInner validate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName,
        CustomizedAcceleratorProperties properties);

    /**
     * Check the customized accelerator are valid.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param properties Customized accelerator properties to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return validation result for customized accelerator properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomizedAcceleratorValidateResultInner validate(String resourceGroupName, String serviceName,
        String applicationAcceleratorName, String customizedAcceleratorName, CustomizedAcceleratorProperties properties,
        Context context);
}
