/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.TriggeredBuildResultProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TriggeredBuildResult
implements JsonSerializable<TriggeredBuildResult> {
    private String id;
    private TriggeredBuildResultProvisioningState provisioningState;
    private String image;
    private OffsetDateTime lastTransitionTime;
    private String lastTransitionReason;
    private String lastTransitionStatus;

    public String id() {
        return this.id;
    }

    public TriggeredBuildResult withId(String id) {
        this.id = id;
        return this;
    }

    public TriggeredBuildResultProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String image() {
        return this.image;
    }

    public TriggeredBuildResult withImage(String image) {
        this.image = image;
        return this;
    }

    public OffsetDateTime lastTransitionTime() {
        return this.lastTransitionTime;
    }

    public TriggeredBuildResult withLastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    public String lastTransitionReason() {
        return this.lastTransitionReason;
    }

    public TriggeredBuildResult withLastTransitionReason(String lastTransitionReason) {
        this.lastTransitionReason = lastTransitionReason;
        return this;
    }

    public String lastTransitionStatus() {
        return this.lastTransitionStatus;
    }

    public TriggeredBuildResult withLastTransitionStatus(String lastTransitionStatus) {
        this.lastTransitionStatus = lastTransitionStatus;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("lastTransitionTime", this.lastTransitionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastTransitionTime));
        jsonWriter.writeStringField("lastTransitionReason", this.lastTransitionReason);
        jsonWriter.writeStringField("lastTransitionStatus", this.lastTransitionStatus);
        return jsonWriter.writeEndObject();
    }

    public static TriggeredBuildResult fromJson(JsonReader jsonReader) throws IOException {
        return (TriggeredBuildResult)jsonReader.readObject(reader -> {
            TriggeredBuildResult deserializedTriggeredBuildResult = new TriggeredBuildResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTriggeredBuildResult.id = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTriggeredBuildResult.provisioningState = TriggeredBuildResultProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedTriggeredBuildResult.image = reader.getString();
                    continue;
                }
                if ("lastTransitionTime".equals(fieldName)) {
                    deserializedTriggeredBuildResult.lastTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastTransitionReason".equals(fieldName)) {
                    deserializedTriggeredBuildResult.lastTransitionReason = reader.getString();
                    continue;
                }
                if ("lastTransitionStatus".equals(fieldName)) {
                    deserializedTriggeredBuildResult.lastTransitionStatus = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggeredBuildResult;
        });
    }
}

