/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.DevToolPortalInstance;
import com.azure.resourcemanager.appplatform.models.DevToolPortalResourceRequests;
import java.io.IOException;
import java.util.List;

public final class DevToolPortalComponent
implements JsonSerializable<DevToolPortalComponent> {
    private String name;
    private DevToolPortalResourceRequests resourceRequests;
    private List<DevToolPortalInstance> instances;

    public String name() {
        return this.name;
    }

    public DevToolPortalResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<DevToolPortalInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DevToolPortalComponent fromJson(JsonReader jsonReader) throws IOException {
        return (DevToolPortalComponent)jsonReader.readObject(reader -> {
            DevToolPortalComponent deserializedDevToolPortalComponent = new DevToolPortalComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDevToolPortalComponent.name = reader.getString();
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedDevToolPortalComponent.resourceRequests = DevToolPortalResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedDevToolPortalComponent.instances = instances = reader.readArray(reader1 -> DevToolPortalInstance.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDevToolPortalComponent;
        });
    }
}

