// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The settings of Application Configuration Service.
 */
@Fluent
public final class ConfigurationServiceSettings implements JsonSerializable<ConfigurationServiceSettings> {
    /*
     * Property of git environment.
     */
    private ConfigurationServiceGitProperty gitProperty;

    /**
     * Creates an instance of ConfigurationServiceSettings class.
     */
    public ConfigurationServiceSettings() {
    }

    /**
     * Get the gitProperty property: Property of git environment.
     * 
     * @return the gitProperty value.
     */
    public ConfigurationServiceGitProperty gitProperty() {
        return this.gitProperty;
    }

    /**
     * Set the gitProperty property: Property of git environment.
     * 
     * @param gitProperty the gitProperty value to set.
     * @return the ConfigurationServiceSettings object itself.
     */
    public ConfigurationServiceSettings withGitProperty(ConfigurationServiceGitProperty gitProperty) {
        this.gitProperty = gitProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitProperty() != null) {
            gitProperty().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gitProperty", this.gitProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationServiceSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationServiceSettings if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationServiceSettings.
     */
    public static ConfigurationServiceSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationServiceSettings deserializedConfigurationServiceSettings = new ConfigurationServiceSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("gitProperty".equals(fieldName)) {
                    deserializedConfigurationServiceSettings.gitProperty
                        = ConfigurationServiceGitProperty.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationServiceSettings;
        });
    }
}
