// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * KPack Builder properties payload.
 */
@Fluent
public final class BuilderProperties implements JsonSerializable<BuilderProperties> {
    /*
     * Builder provision status.
     */
    private BuilderProvisioningState provisioningState;

    /*
     * Builder cluster stack property.
     */
    private StackProperties stack;

    /*
     * Builder buildpack groups.
     */
    private List<BuildpacksGroupProperties> buildpackGroups;

    /**
     * Creates an instance of BuilderProperties class.
     */
    public BuilderProperties() {
    }

    /**
     * Get the provisioningState property: Builder provision status.
     * 
     * @return the provisioningState value.
     */
    public BuilderProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the stack property: Builder cluster stack property.
     * 
     * @return the stack value.
     */
    public StackProperties stack() {
        return this.stack;
    }

    /**
     * Set the stack property: Builder cluster stack property.
     * 
     * @param stack the stack value to set.
     * @return the BuilderProperties object itself.
     */
    public BuilderProperties withStack(StackProperties stack) {
        this.stack = stack;
        return this;
    }

    /**
     * Get the buildpackGroups property: Builder buildpack groups.
     * 
     * @return the buildpackGroups value.
     */
    public List<BuildpacksGroupProperties> buildpackGroups() {
        return this.buildpackGroups;
    }

    /**
     * Set the buildpackGroups property: Builder buildpack groups.
     * 
     * @param buildpackGroups the buildpackGroups value to set.
     * @return the BuilderProperties object itself.
     */
    public BuilderProperties withBuildpackGroups(List<BuildpacksGroupProperties> buildpackGroups) {
        this.buildpackGroups = buildpackGroups;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (stack() != null) {
            stack().validate();
        }
        if (buildpackGroups() != null) {
            buildpackGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("stack", this.stack);
        jsonWriter.writeArrayField("buildpackGroups", this.buildpackGroups,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuilderProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuilderProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuilderProperties.
     */
    public static BuilderProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuilderProperties deserializedBuilderProperties = new BuilderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedBuilderProperties.provisioningState
                        = BuilderProvisioningState.fromString(reader.getString());
                } else if ("stack".equals(fieldName)) {
                    deserializedBuilderProperties.stack = StackProperties.fromJson(reader);
                } else if ("buildpackGroups".equals(fieldName)) {
                    List<BuildpacksGroupProperties> buildpackGroups
                        = reader.readArray(reader1 -> BuildpacksGroupProperties.fromJson(reader1));
                    deserializedBuilderProperties.buildpackGroups = buildpackGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuilderProperties;
        });
    }
}
