// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Remote debugging config.
 */
@Fluent
public final class RemoteDebuggingInner implements JsonSerializable<RemoteDebuggingInner> {
    /*
     * Application debugging port
     */
    private Integer port;

    /*
     * Indicate if remote debugging is enabled
     */
    private Boolean enabled;

    /**
     * Creates an instance of RemoteDebuggingInner class.
     */
    public RemoteDebuggingInner() {
    }

    /**
     * Get the port property: Application debugging port.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Application debugging port.
     * 
     * @param port the port value to set.
     * @return the RemoteDebuggingInner object itself.
     */
    public RemoteDebuggingInner withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the enabled property: Indicate if remote debugging is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicate if remote debugging is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the RemoteDebuggingInner object itself.
     */
    public RemoteDebuggingInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoteDebuggingInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoteDebuggingInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RemoteDebuggingInner.
     */
    public static RemoteDebuggingInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RemoteDebuggingInner deserializedRemoteDebuggingInner = new RemoteDebuggingInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("port".equals(fieldName)) {
                    deserializedRemoteDebuggingInner.port = reader.getNullable(JsonReader::getInt);
                } else if ("enabled".equals(fieldName)) {
                    deserializedRemoteDebuggingInner.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRemoteDebuggingInner;
        });
    }
}
