// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.models.ApiPortalCustomDomainResourceInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ApiPortalCustomDomainsClient.
 */
public interface ApiPortalCustomDomainsClient {
    /**
     * Get the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API portal custom domain along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApiPortalCustomDomainResourceInner>> getWithResponseAsync(String resourceGroupName,
        String serviceName, String apiPortalName, String domainName);

    /**
     * Get the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API portal custom domain on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiPortalCustomDomainResourceInner> getAsync(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName);

    /**
     * Get the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API portal custom domain along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiPortalCustomDomainResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName, Context context);

    /**
     * Get the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API portal custom domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiPortalCustomDomainResourceInner get(String resourceGroupName, String serviceName, String apiPortalName,
        String domainName);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain of the API portal along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of custom domain of the API portal.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName,
            ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of custom domain of the API portal.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String apiPortalName, String domainName,
        ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of custom domain of the API portal.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ApiPortalCustomDomainResourceInner>, ApiPortalCustomDomainResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String apiPortalName, String domainName,
        ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource, Context context);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain of the API portal on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiPortalCustomDomainResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain of the API portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiPortalCustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource);

    /**
     * Create or update the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param apiPortalCustomDomainResource The API portal custom domain for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain of the API portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiPortalCustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName, ApiPortalCustomDomainResourceInner apiPortalCustomDomainResource,
        Context context);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String apiPortalName, String domainName);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apiPortalName,
        String domainName);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apiPortalName,
        String domainName, Context context);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apiPortalName, String domainName);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String apiPortalName, String domainName);

    /**
     * Delete the API portal custom domain.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String apiPortalName, String domainName, Context context);

    /**
     * Handle requests to list all API portal custom domains.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of API portal custom domain resources and a possible link for next set as
     * paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApiPortalCustomDomainResourceInner> listAsync(String resourceGroupName, String serviceName,
        String apiPortalName);

    /**
     * Handle requests to list all API portal custom domains.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of API portal custom domain resources and a possible link for next set as
     * paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiPortalCustomDomainResourceInner> list(String resourceGroupName, String serviceName,
        String apiPortalName);

    /**
     * Handle requests to list all API portal custom domains.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param apiPortalName The name of API portal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of API portal custom domain resources and a possible link for next set as
     * paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiPortalCustomDomainResourceInner> list(String resourceGroupName, String serviceName,
        String apiPortalName, Context context);
}
