// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Scheme to use for connecting to the host. Defaults to HTTP.
 * 
 * Possible enum values:
 * - `"HTTP"` means that the scheme used will be http://
 * - `"HTTPS"` means that the scheme used will be https://.
 */
public final class HttpSchemeType extends ExpandableStringEnum<HttpSchemeType> {
    /**
     * Static value HTTP for HttpSchemeType.
     */
    public static final HttpSchemeType HTTP = fromString("HTTP");

    /**
     * Static value HTTPS for HttpSchemeType.
     */
    public static final HttpSchemeType HTTPS = fromString("HTTPS");

    /**
     * Creates a new instance of HttpSchemeType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public HttpSchemeType() {
    }

    /**
     * Creates or finds a HttpSchemeType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding HttpSchemeType.
     */
    @JsonCreator
    public static HttpSchemeType fromString(String name) {
        return fromString(name, HttpSchemeType.class);
    }

    /**
     * Gets known HttpSchemeType values.
     * 
     * @return known HttpSchemeType values.
     */
    public static Collection<HttpSchemeType> values() {
        return values(HttpSchemeType.class);
    }
}
