// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Detail settings for Dev Tool Portal feature.
 */
@Fluent
public final class DevToolPortalFeatureDetail {
    /*
     * State of the plugin
     */
    @JsonProperty(value = "state")
    private DevToolPortalFeatureState state;

    /*
     * Route path to visit the plugin
     */
    @JsonProperty(value = "route", access = JsonProperty.Access.WRITE_ONLY)
    private String route;

    /**
     * Creates an instance of DevToolPortalFeatureDetail class.
     */
    public DevToolPortalFeatureDetail() {
    }

    /**
     * Get the state property: State of the plugin.
     * 
     * @return the state value.
     */
    public DevToolPortalFeatureState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the plugin.
     * 
     * @param state the state value to set.
     * @return the DevToolPortalFeatureDetail object itself.
     */
    public DevToolPortalFeatureDetail withState(DevToolPortalFeatureState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the route property: Route path to visit the plugin.
     * 
     * @return the route value.
     */
    public String route() {
        return this.route;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
