// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Application accelerator properties payload.
 */
@Immutable
public final class ApplicationAcceleratorProperties {
    /*
     * State of the application accelerator.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ApplicationAcceleratorProvisioningState provisioningState;

    /*
     * Collection of components belong to application accelerator.
     */
    @JsonProperty(value = "components", access = JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationAcceleratorComponent> components;

    /**
     * Creates an instance of ApplicationAcceleratorProperties class.
     */
    public ApplicationAcceleratorProperties() {
    }

    /**
     * Get the provisioningState property: State of the application accelerator.
     * 
     * @return the provisioningState value.
     */
    public ApplicationAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the components property: Collection of components belong to application accelerator.
     * 
     * @return the components value.
     */
    public List<ApplicationAcceleratorComponent> components() {
        return this.components;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
    }
}
