// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Auth setting for basic auth.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "authType")
@JsonTypeName("BasicAuth")
@Fluent
public final class AcceleratorBasicAuthSetting extends AcceleratorAuthSetting {
    /*
     * Resource Id of CA certificate for https URL of Git repository.
     */
    @JsonProperty(value = "caCertResourceId")
    private String caCertResourceId;

    /*
     * Username of git repository basic auth.
     */
    @JsonProperty(value = "username", required = true)
    private String username;

    /*
     * Password of git repository basic auth.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Creates an instance of AcceleratorBasicAuthSetting class.
     */
    public AcceleratorBasicAuthSetting() {
    }

    /**
     * Get the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @return the caCertResourceId value.
     */
    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    /**
     * Set the caCertResourceId property: Resource Id of CA certificate for https URL of Git repository.
     * 
     * @param caCertResourceId the caCertResourceId value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    /**
     * Get the username property: Username of git repository basic auth.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Username of git repository basic auth.
     * 
     * @param username the username value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password of git repository basic auth.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password of git repository basic auth.
     * 
     * @param password the password value to set.
     * @return the AcceleratorBasicAuthSetting object itself.
     */
    public AcceleratorBasicAuthSetting withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (username() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property username in model AcceleratorBasicAuthSetting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorBasicAuthSetting.class);
}
