// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Auth setting payload.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "authType",
    defaultImpl = AcceleratorAuthSetting.class)
@JsonTypeName("AcceleratorAuthSetting")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Public", value = AcceleratorPublicSetting.class),
    @JsonSubTypes.Type(name = "BasicAuth", value = AcceleratorBasicAuthSetting.class),
    @JsonSubTypes.Type(name = "SSH", value = AcceleratorSshSetting.class) })
@Immutable
public class AcceleratorAuthSetting {
    /**
     * Creates an instance of AcceleratorAuthSetting class.
     */
    public AcceleratorAuthSetting() {
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
