// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Settings for Dev Tool Portal.
 */
@Fluent
public final class DevToolPortalFeatureSettings {
    /*
     * Detail of Accelerator plugin
     */
    @JsonProperty(value = "applicationAccelerator")
    private DevToolPortalFeatureDetail applicationAccelerator;

    /*
     * Detail of App Live View plugin
     */
    @JsonProperty(value = "applicationLiveView")
    private DevToolPortalFeatureDetail applicationLiveView;

    /**
     * Creates an instance of DevToolPortalFeatureSettings class.
     */
    public DevToolPortalFeatureSettings() {
    }

    /**
     * Get the applicationAccelerator property: Detail of Accelerator plugin.
     * 
     * @return the applicationAccelerator value.
     */
    public DevToolPortalFeatureDetail applicationAccelerator() {
        return this.applicationAccelerator;
    }

    /**
     * Set the applicationAccelerator property: Detail of Accelerator plugin.
     * 
     * @param applicationAccelerator the applicationAccelerator value to set.
     * @return the DevToolPortalFeatureSettings object itself.
     */
    public DevToolPortalFeatureSettings withApplicationAccelerator(DevToolPortalFeatureDetail applicationAccelerator) {
        this.applicationAccelerator = applicationAccelerator;
        return this;
    }

    /**
     * Get the applicationLiveView property: Detail of App Live View plugin.
     * 
     * @return the applicationLiveView value.
     */
    public DevToolPortalFeatureDetail applicationLiveView() {
        return this.applicationLiveView;
    }

    /**
     * Set the applicationLiveView property: Detail of App Live View plugin.
     * 
     * @param applicationLiveView the applicationLiveView value to set.
     * @return the DevToolPortalFeatureSettings object itself.
     */
    public DevToolPortalFeatureSettings withApplicationLiveView(DevToolPortalFeatureDetail applicationLiveView) {
        this.applicationLiveView = applicationLiveView;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (applicationAccelerator() != null) {
            applicationAccelerator().validate();
        }
        if (applicationLiveView() != null) {
            applicationLiveView().validate();
        }
    }
}
